/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.integration.config;

import cofh.core.config.IBaseConfig;
import cofh.thermal.integration.config.ModSupportConfig;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class TIntConfig
implements IBaseConfig {
    protected static final List<ModSupportConfig> MOD_CONFIGS = new ArrayList<ModSupportConfig>();
    private Supplier<Boolean> boolRoseGold;
    private Supplier<Boolean> boolSteel;

    public static void addModConfig(String modId, String name) {
        MOD_CONFIGS.add(new ModSupportConfig(modId, name));
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Materials");
        this.boolRoseGold = builder.comment("If TRUE, Thermal Series' Rose Gold material and recipes are enabled.").define("Rose Gold", true);
        this.boolSteel = builder.comment("If TRUE, Thermal Series' Steel material and recipes are enabled.").define("Steel", true);
        builder.pop();
        builder.push("Mod Compatibility");
        for (IBaseConfig iBaseConfig : MOD_CONFIGS) {
            iBaseConfig.apply(builder);
        }
        builder.pop();
    }

    public void refresh() {
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_ROSE_GOLD, (boolean)this.boolRoseGold.get());
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_STEEL, (boolean)this.boolSteel.get());
        for (IBaseConfig iBaseConfig : MOD_CONFIGS) {
            iBaseConfig.refresh();
        }
    }
}

